import React from 'react';
import logo from './logo.svg';
import './App.css';
import {  BrowserRouter as Router, Navigate, Route, Routes } from 'react-router-dom'
import { EntryPage } from './components/entry-page/EntryPage';
import { RegisterForm } from './components/register/RegisterForm';
import { LoginForm } from './components/LoginForm';

function App() {
	return (
		<Router>
			<Routes>
				<Route path='register/:buildingId' element={<EntryPage children={<RegisterForm/>}/>} />
				<Route path='register/error' element={<EntryPage children={<div>Invalid invitational link - screen to be implemented</div>} />} />
				<Route path='login' element={<EntryPage children={<LoginForm />}/>}/>
				<Route path='*' element={<Navigate replace to="login"/>} /> 
			</Routes>
		</Router>
  	);
}

export default App;
