import { useEffect, useState } from "react";
import { getBuilding } from "../../actions/data-manager";
import { TabWrapper } from "../TabWrapper/TabWrapper";
import { BuildingInvoicesList } from "./BuildingInvoicesList";

export const BuildingInvoices = ({ buildingId }: { buildingId: string }) => {

    const [building, setBuilding] = useState<any>();

    useEffect(() => {
        getBuilding(buildingId, (err: any, data: any) => { setBuilding(data) });
    }, []);


    return (
        <>
            {building &&
                <TabWrapper header='Finansije Zgrade'>
                    <BuildingInvoicesList building={building} />
                </TabWrapper>
            }
        </>
    );
}