import { Table, TableBody, TableCell, TableContainer, TableHead, TableRow } from "@mui/material";
import { useTranslation } from "react-i18next";
import { Card } from "../Card/Card";
import { PayableStatus } from "./PayableStatus";

const classes = {
    tableHead: {
        '& .MuiTableCell-root': {
            color: '#64748b',
            fontWeight: 'bold',
            paddingBlock: '8px',
            paddingInline: '0px',
        }
    },
    tableBody: {
        '& .MuiTableCell-root': {
            paddingInline: '0px',
        }
    },
    bolder: {
        fontWeight: 'bolder'
    },
    status: {
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center'
    }

} as const;

export const BuildingInvoicesList = ({ building }: { building: any }) => {

    const { t } = useTranslation();

    let finance = building.finance || {}

    let buildingPayable = building.finance && building.finance.payable && building.finance.payable.reduce((acc: any, x: any) => acc + x.price, 0)
    let inflowSum = building.finance && building.finance.inflow && building.finance.inflow.reduce((acc: any, x: any) => acc + x.amount, 0)
    let outflowSum = building.finance && building.finance.outflow && building.finance.outflow.reduce((acc: any, x: any) => acc + x.amount, 0)
    let sumFundsPayables = (building.finance && building.finance.fund && building.finance.fund.reduce((acc: any, x: any) => acc + (x.receivable || 0), 0) || 0)


    let fullBalance = building.finance && inflowSum && buildingPayable && (inflowSum - buildingPayable - sumFundsPayables)
    let cashBalance = building.finance && building.finance.balance
    let calculatedCashBalance = building.finance && (inflowSum - outflowSum)

    let outflows = building.finance ? building.finance.outflow : []

    let fundMap = (finance.fund || []).reduce((a: any, x: any) => ({ ...a, [x._id]: x.name }), {})
    let fundOutflows = (outflows || []).filter((x: any) => !!x.fundId)
    fundOutflows = fundOutflows.map((x: any) => ({ name: x.reason, price: x.amount, accounting: fundMap[x.fundId], created: x.date, type: "fund" }))

    let payables = building.finance ? building.finance.payable : []

    payables.push(...fundOutflows)

    payables.sort((a: any, b: any) => Date.parse(a.created) - Date.parse(b.created))

    return (
        <Card>
            <TableContainer >
                <Table size="medium">
                    <TableHead>
                        <TableRow sx={classes.tableHead}>
                            <TableCell align="left">{t("Payables")}</TableCell>
                            <TableCell align="center">{t("Date")}</TableCell>
                            <TableCell align="center">{t("Accounting")}</TableCell>
                            <TableCell align="center">{t("Total")}</TableCell>
                            <TableCell align="center">{t("Status")}</TableCell>
                        </TableRow>
                    </TableHead>
                    <TableBody>
                        {payables.map((payable: any) => (
                            <TableRow key={payable._id} sx={classes.tableBody}>
                                <TableCell align="left">{payable.name} </TableCell>
                                <TableCell align="center">{t("formatDate", { date: new Date(payable.created) })}</TableCell>
                                <TableCell align="center">{t(payable.accounting)} </TableCell>
                                <TableCell align="center" sx={classes.bolder}>{t("priceFormat", { num: (payable.unitPrice || payable.price) })}</TableCell>
                                <TableCell sx={classes.status}><PayableStatus status={payable.status === "paid" || payable.type === "fund"} /></TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </TableContainer>
        </Card>
    );
}