import { Button, TextField } from "@mui/material"
import { useState } from "react";
import { LoginInfo } from "../internal-types";

const classes = {
    textField: {
        '& label.Mui-focused': {
            color: 'rgb(30, 41, 60)'
        },
        '& .MuiOutlinedInput-root': {
            '& input': {
                zIndex: '5'
            },
            '& fieldset': {
                borderColor: 'rgb(203, 213, 224)',
                backgroundColor: 'white'
            },
            '&:hover fieldset': {
                borderColor: 'rgb(203, 213, 224)',
            },
            '&.Mui-focused': {
                '& fieldset': {
                    borderColor: 'rgb(203, 213, 224)'
                }
            },
        }
    },
    select: {
        '& label.Mui-focused': {
            color: 'red'
        }
        ,
        '& fieldset': {
            borderColor: 'rgb(203, 213, 224)',
            backgroundColor: 'white',
            zIndex: 0
        },
        '& svg': {
            zIndex: 2
        },
        '& div': {
            zIndex: 3
        },

    },
    loginButton: {
        alignSelf: 'flex-end',
        '&.MuiButton-root': {
            backgroundColor: 'rgb(19, 71, 175)',
            borderRadius: 40,
            padding: '10px',
            paddingInline: '25px'
        }
    }
} as const;

export const LoginForm = () => {

    const [loginInfo, setLoginInfo] = useState<LoginInfo>({username: '', password: ''});

    return (
        <>
            <TextField
                variant="outlined"
                size='small'
                label="Username"
                sx={classes.textField}
                value={loginInfo.username}
                onChange={(e) => {
                    setLoginInfo({...loginInfo, username: e.target.value})
                }}
            />
            <TextField
                variant="outlined"
                size='small'
                type="password"
                label="Password"
                sx={classes.textField}
                value={loginInfo.password}
                onChange={(e) => {
                    setLoginInfo({...loginInfo, password: e.target.value})
                }}
            />
            <Button sx={classes.loginButton} variant='contained'>Login</Button>
        </>)
}