import { TextField, Box, Typography, Button, styled, ButtonProps, Select, FormControl, InputLabel, MenuItem } from "@mui/material";
import { red } from "@mui/material/colors";
import React, { useEffect, useState } from "react";
import { Navigate, useParams } from "react-router-dom";
import { getPreRegisterData } from "../../actions/data-manager";
import { RegistrationInfo } from "../../internal-types";

const classes = {
    textField: {
        flex: 1,
        '& label.Mui-focused': {
            color: 'rgb(30, 41, 60)'
        },
        '& .MuiOutlinedInput-root': {
            '& input': {
                zIndex: '5'
            },
            '& fieldset': {
                borderColor: 'rgb(203, 213, 224)',
                backgroundColor: 'white'
            },
            '&:hover fieldset': {
                borderColor: 'rgb(203, 213, 224)',
            },
            '&.Mui-focused': {
                '& fieldset': {
                    borderColor: 'rgb(203, 213, 224)'
                }
            },
        }
    },
    select: {
        '& label.Mui-focused': {
            color: 'red'
        }
        ,
        '& fieldset': {
            borderColor: 'rgb(203, 213, 224)',
            backgroundColor: 'white',
            zIndex: 0
        },
        '& svg': {
            zIndex: 2
        },
        '& div': {
            zIndex: 3
        },

    },
    registerButton: {
        alignSelf: 'flex-end',
        '&.MuiButton-root': {
            backgroundColor: 'rgb(19, 71, 175)',
            borderRadius: 40,
            padding: '10px',
            paddingInline: '25px'
        }
    }
} as const;

export const RegisterForm = (): JSX.Element => {

    let { buildingId } = useParams();

    const [buildingUnits, setBuildingUnits] = useState([]);
    const [invalidUrl, setInvalidUrl] = useState(false);
    const [registerInfo, setRegisterInfo] = useState<RegistrationInfo>({ name: '', lastName: '', email: '', username: '', password: '', mobile: '', units: [] });

    useEffect(() => {
        getPreRegisterData(buildingId, (err: any, data: any, dsp: any) => {
            if (err) {
                setInvalidUrl(true);
                return;
            }

            setBuildingUnits(data.units);
        });
    }, [])

    useEffect(() => {
        console.log(registerInfo.units)
    }, [registerInfo.units])

    return (
        <>
            {invalidUrl && <Navigate replace to='../register/error' />}
            {buildingUnits &&
                <Box sx={{display: 'flex', flexDirection: 'column', gap: '20px'}}>
                    <Box sx={{ display: 'flex', gap: '20px' }}>
                        <TextField
                            hiddenLabel
                            variant="outlined"
                            size='small'
                            label="First name"
                            sx={classes.textField}
                            value={registerInfo.name}
                            onChange={(e) => {
                                setRegisterInfo({ ...registerInfo, name: e.target.value })
                            }} />
                        <TextField
                            hiddenLabel
                            variant="outlined"
                            size='small'
                            label="Last name"
                            sx={classes.textField}
                            value={registerInfo.lastName}
                            onChange={(e) => {
                                setRegisterInfo({ ...registerInfo, lastName: e.target.value })
                            }} />
                    </Box>

                    <TextField
                        variant="outlined"
                        size='small'
                        label="Email"
                        sx={classes.textField}
                        value={registerInfo.email}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, email: e.target.value })
                        }}
                    />
                    <TextField
                        variant="outlined"
                        size='small'
                        label="Username"
                        sx={classes.textField}
                        value={registerInfo.username}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, username: e.target.value })
                        }}
                    />
                    <TextField
                        variant="outlined"
                        size='small'
                        label="Password"
                        type="password"
                        sx={classes.textField}
                        value={registerInfo.password}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, password: e.target.value })
                        }}
                    />
                    <TextField
                        variant="outlined"
                        size='small'
                        label="Mobile number"
                        type="number"
                        sx={classes.textField}
                        value={registerInfo.mobile}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, mobile: e.target.value })
                        }}
                    />
                    <FormControl fullWidth size="small">
                        <InputLabel>Select your units</InputLabel>
                        <Select
                            label="Select your units"
                            sx={classes.select}
                            value={registerInfo.units}
                            multiple
                            onChange={(e) => {
                                let units: string[] = typeof e.target.value === 'string' ? e.target.value.split(',') : e.target.value;
                                setRegisterInfo({ ...registerInfo, units })
                            }}
                        >
                            {buildingUnits.map((unit: any, index) => <MenuItem value={unit.address} key={index}>{unit.address}</MenuItem>)}
                        </Select>
                    </FormControl>

                    <Button sx={classes.registerButton} variant='contained'>Register</Button>
                </Box>
            }
        </>);
};