import { Box } from "@mui/material"
import jwtDecode from "jwt-decode";
import { useState } from "react";
import { Navigate, Route, Routes } from "react-router-dom";
import { JWT_TENANT } from "../actions/network-manager";
import { BuildingInvoices } from "./BuildingInvoices/BuildingInvoices";
import { Settings } from "./Settings/Settings";
import { Voting } from "./Voting/Voting";

const classes = {
    wrapper: {
        backgroundColor: 'rgb(241, 245, 249)',
        minHeight: '95vh',
        width: '100%',
        boxSizing: 'border-box',
        paddingBlock: '3%',
        paddingInline: '11%',
        '@media (max-width: 800px)': {
            paddingInline: '5%',
        }
    }
} as const ;

export const ApplicationTab = () => {

    const getBuildingId = () => {
        let res: any = jwtDecode(localStorage.getItem(JWT_TENANT)!);
        return res.bl[0].id;
    }

    const [buildingId, setBuildingId] = useState(getBuildingId());

    return (
        <Box sx={classes.wrapper}>
                <Routes>
                    <Route path='overview' element={<div>Hello from overview</div>} />
                    <Route path='notifications' element={<div>Hello from notifications</div>} />
                    <Route path='issues' element={<div>Hello from issues</div>} />
                    <Route path='voting' element={<Voting buildingId={buildingId}/>} />
                    <Route path='invoices' element={<div>Hello from invoices</div>} />
                    <Route path='building-invoices' element={<BuildingInvoices buildingId={buildingId}/>} />
                    <Route path='documents' element={<div>Hello from documents</div>} />
                    <Route path='settings' element={<Settings />} />
                    <Route path='*' element={<Navigate replace to="overview" />} />
                </Routes>
        </Box>
    )
}