import { SubMenu } from "../../internal-types";
import { ActivityIcon } from "../icons/ActivityIcon";
import { BuidlingInvoicesIcon } from "../icons/BuildingInvoicesIcon";
import { DocumentIcon } from "../icons/DocumentIcon";
import { HomeIcon } from "../icons/HomeIcon";
import { InvoicesIcon } from "../icons/InvoicesIcon";
import { LanguageIcon } from "../icons/LanguageIcon";
import { NotificationIcon } from "../icons/NotificationIcon";
import { SettingsIcon } from "../icons/SettingsIcon";
import { VotingIcon } from "../icons/VotingIcon";


export const subMenu: SubMenu[] = [
    {
        title: 'Glavni meni',
        items: [
            { title: 'Pregled', icon: <HomeIcon />, path: 'overview' },
            { title: 'Obaveštenja', icon: <NotificationIcon />, path: 'notifications' },
            { title: 'Aktivnosti', icon: <ActivityIcon />, path: 'issues' },
            { title: 'Glasanje', icon: <VotingIcon />, path: 'voting' }
        ]
    },
    {
        title: 'Računi/Finansije',
        items: [
            { title: 'Moj Račun', icon: <InvoicesIcon />, path: 'invoices' },
            { title: 'Finansije zgrade', icon: <BuidlingInvoicesIcon />, path: 'building-invoices' },
            { title: 'Dokumenta', icon: <DocumentIcon />, path: 'documents' }]
    },
    {
        title: 'Aplikacija',
        items: [
            { title: 'Podešavanja', icon: <SettingsIcon /> },
            { title: 'English', icon: <LanguageIcon /> }]
    }

];