import { Typography } from "@mui/material";
import { TabWrapper } from "../TabWrapper/TabWrapper";
import { Issue } from "./Issue";

export const Issues = ({ issues }: { issues: any }) => {



    return (
        <TabWrapper header="Aktivnosti">
            {
                issues.map((issue: any, index: number) => (
                    <Issue issue={issue} key={index}/>
                ))
            }
            {issues.length === 0 && <Typography>Trenutno nema aktivnosti za ovu jedinicu.</Typography>}
        </TabWrapper>
    );
}