import { Typography } from "@mui/material";
import { TabWrapper } from "../TabWrapper/TabWrapper";
import { Notification } from "./Notification";

export const Notifications = ({ notifications }: { notifications: any }) => {
    
    return (
        <TabWrapper header="Obaveštenja">
            {
                notifications.map((notification: any, index: number) => (
                    <Notification title={notification.title} description={notification.description} />
                ))
            }
            {notifications.length === 0 && <Typography>Trenutno nema obavestenja za ovu jedinicu.</Typography>}
        </TabWrapper>);
}