import { Box, Divider, Typography } from "@mui/material";
import { useTranslation } from "react-i18next";
import { Card } from "../Card/Card";
import { PaymentOrderItem } from "./PaymentOrderItem";

const classes = {
    title: {
        marginLeft: 'auto'
    },
    mainContainer: {
        display: 'flex',
        alignItems: 'center'
    },
    itemsContainer: {
        flex: 1,
        display: 'flex',
        flexDirection: 'column',
        boxSizing: 'border-box',
        paddingBlock: '20px',
        gap: '5px'
    },
    divider: {
        marginInline: '10px'
    },
    itemsGroup: {
        display: 'flex',
        gap: '10px',
        alignItems: 'flex-end'
    }

} as const;

export const PaymentOrder = ({ recipient, debit, bankAccount, payReference }: { recipient: string, debit: number, bankAccount: string, payReference: string }) => {

    const { t } = useTranslation();

    return (
        <Card>
            <Typography sx={classes.title}>Nalog za uplatu</Typography>
            <Box sx={classes.mainContainer}>
                <Box sx={classes.itemsContainer}>
                    <PaymentOrderItem flex={1} label="Uplatilac" size="large" />
                    <PaymentOrderItem flex={1} label="Svrha uplate" size="large" />
                    <PaymentOrderItem flex={1} label="Primalac" size="large" value={recipient} />
                </Box>
                <Divider sx={classes.divider} orientation="vertical" variant="middle" flexItem />
                <Box sx={classes.itemsContainer}>
                    <Box sx={classes.itemsGroup}>
                        <PaymentOrderItem flex={1} label='sifra placanja' size="small" />
                        <PaymentOrderItem flex={1} label='valuta' size="small" value="RSD" />
                        <PaymentOrderItem flex={4} label='iznos' size="small" value={t("nalog", { num: (debit > 0 ? debit : 0) })} />
                    </Box>
                    <PaymentOrderItem flex={1} label='Racun primaonca' size="small" value={bankAccount} />
                    <Box sx={classes.itemsGroup}>
                        <PaymentOrderItem flex={1} label='model' size="small" />
                        <PaymentOrderItem flex={4} label='poziv na broj' size="small" value={payReference} />
                    </Box>
                </Box>
            </Box>
        </Card>
    );
}