import { Box } from "@mui/material";
import { useEffect } from "react"
import { useNavigate } from "react-router-dom"
import { JWT_TENANT } from "../actions/network-manager"
import { ApplicationTab } from "./ApplicationTab";
import { NavBar } from "./NavBar";
import { SideMenu } from "./SideMenu";

const classes = {
    mainWrapper: {
        display: 'flex',
        flexDirection: 'row'
    },
    rightSideWrapper: {
        display: 'flex',
        flexDirection: 'column',
        width: '85%'
    }
} as const;

export const Application = () => {

    const navigate = useNavigate();

    useEffect(() => {
        if (!localStorage.getItem(JWT_TENANT)) {
            navigate('../login');
        }
    }, [navigate])

    return (
        <Box sx={classes.mainWrapper}>
            <SideMenu />
            <Box sx={classes.rightSideWrapper}>
                <NavBar />
                <ApplicationTab />
            </Box>
        </Box>
    )
}