import { Box, Typography } from "@mui/material";
import { ReactNode } from "react";

const classes = {
    wrapper: { 
        height: '100%',
        display: 'flex', 
        flexDirection: 'column',
        justifyContent: 'center',
        gap: '20px' 
    },
    title: { 
        fontFamily: 'Inter', 
        fontWeight: 'bold',
    }
} as const;

export const Form = ({ children, title }: { children?: ReactNode, title: string }) => {
    return (
        <Box style={classes.wrapper}>
            <Typography sx={classes.title} variant='h4'>{title}</Typography>
            {children}
        </Box>
    );
}