import { Box, Typography } from "@mui/material";
import { useEffect, useState } from "react";
import { getBuilding } from "../../actions/data-manager";
import { BuildingInvoicesList } from "./BuildingInvoicesList";

const classes = {
    wrapper: {
        display: 'flex',
        flexDirection: 'column',
        gap: '50px',
    },
    header: {
        fontWeight: 600,
        fontSize: '1.6em',
        color: '#27313a'
    }
} as const;

export const BuildingInvoices = () => {

    const [building, setBuilding] = useState<any>();

    useEffect(() => {
        getBuilding('62a1ca0cf2c321d1f5d4aa8d', (err: any, data: any) => {setBuilding(data)});
    }, []);


    return (
        <>
        { building &&
        <Box sx={classes.wrapper}>
            <Typography variant="h5" sx={classes.header}>Finansije Zgrade</Typography>
            <BuildingInvoicesList building={building}/>
        </Box>
        }
        </>
    );
}