import { Box, Typography } from "@mui/material";
import { useNavigate } from "react-router-dom";
import { SubMenu } from "../internal-types";

const classes = {
    wrapper: {
        display: 'flex',
        flexDirection: 'column',
        color: 'white',
        gap: '5px',
    },
    itemTitle: {
        color: 'rgb(24, 95, 167)',
        paddingInline: '10%',
    },
    itemsWrapper: {
        display: 'flex',
        flexDirection: 'row',
        gap: '15px',
        alignItems: 'center',
        paddingInline: '10%',
        paddingBlock: '2.5px',
        boxSizing: 'border-box',
        borderRadius: '5px',
        userSelect: 'none',
        cursor: 'pointer',
        ':hover': {
            backgroundColor: 'rgba(150, 150, 150, 0.2)'
        }
    },
    selectedItem: {
        backgroundColor: 'rgba(200, 200, 200, 0.3)',
        '& .MuiTypography-root': {
            fontWeight: 'bold'
        },
        '&:hover': {
            backgroundColor: 'rgba(200, 200, 200, 0.3)'
        },
        '& .icons-stroke': {
            stroke: 'white'
        }
    }
} as const;

export const SideMenuItem = ({ content, selectedItem, changeSelectedItem }: { content: SubMenu, selectedItem: string, changeSelectedItem: (item: string) => void }) => {

    const navigate = useNavigate();

    return (
        <Box sx={classes.wrapper}>
            <Typography sx={classes.itemTitle}> {content.title.toUpperCase()}</Typography>
            {content.items.map((item, ind) => (
                <Box sx={selectedItem === item.path ? { ...classes.itemsWrapper, ...classes.selectedItem } : classes.itemsWrapper} key={ind} onClick={() => {
                    if (item.path) {
                        navigate(item.path);
                        changeSelectedItem(item.path);
                    }
                }}>
                    {!!item.icon && item.icon}
                    <Typography sx={{color: 'white'}}>{item.title}</Typography>
                </Box>
            ))}
        </Box>
    );
}