import { Box, Typography } from "@mui/material";
import { SubMenu } from "../internal-types";

const classes = {
    wrapper : { 
        display: 'flex', 
        flexDirection: 'column', 
        color: 'white', 
        paddingInline: '10%', 
        gap: '10px' 
    },
    itemTitle: { 
        color: 'rgb(24, 95, 167)'
    },
    itemsWrapper: { 
        display: 'flex', 
        flexDirection: 'row', 
        gap: '10%', 
        alignItems: 'center' 
    }
} as const;

export const SideMenuItem = ({ content }: { content: SubMenu }) => {
    return (
        <Box sx={classes.wrapper}>
            <Typography sx={classes.itemTitle}> {content.title.toUpperCase()}</Typography>
            {content.items.map((item, ind) => (
                <Box sx={classes.itemsWrapper} key={ind}>
                    {!!item.icon && item.icon}
                    <Typography>{item.title}</Typography>
                </Box>
            ))}
        </Box>
    );
}