import { TextField, Box, Typography, Button, styled, ButtonProps, Select, FormControl, InputLabel, MenuItem } from "@mui/material";
import { red } from "@mui/material/colors";
import React from "react";
import { useParams } from "react-router-dom";

const classes = {
    textField: {
        flex: 1,
        '& label.Mui-focused': {
            color: 'rgb(30, 41, 60)'
        },
        '& .MuiOutlinedInput-root': {
            '& fieldset': {
                borderColor: 'rgb(203, 213, 224)',
                backgroundColor: 'white'
            },
            '&:hover fieldset': {
                borderColor: 'rgb(203, 213, 224)',
            },
            '&.Mui-focused': {
                '& fieldset': {
                    borderColor: 'rgb(203, 213, 224)'
                }
            },
        }
    },
    select: {
        '& label.Mui-focused': {
            color: 'red'
        }
        ,
        '& fieldset': {
            borderColor: 'rgb(203, 213, 224)',
            backgroundColor: 'white',
            zIndex: 0
        },
        '& svg': {
            zIndex: 2
        }

    },
    registerButton: {
        alignSelf: 'flex-end',
        '&.MuiButton-root': {
            backgroundColor: 'rgb(19, 71, 175)',
            borderRadius: 40,
            padding: '10px',
            paddingInline: '25px'
        }
    }
} as const;

export const RegisterForm = () => {

    let { buildingId } = useParams();

    console.log(buildingId);

    return (
        <div style={{ display: 'flex', flexDirection: 'column', gap: '20px' }}>
            <Typography sx={{ fontFamily: 'Inter', fontWeight: 'bold' }} variant='h4'>Create Account</Typography>
            <Box sx={{ display: 'flex', gap : '20px' }}>
                <TextField hiddenLabel variant="outlined" size='small' label="First name" sx={classes.textField} />
                <TextField hiddenLabel variant="outlined" size='small' label="Last name" sx={classes.textField} />
            </Box>

            <TextField variant="outlined" size='small' label="Email" sx={classes.textField} />
            <TextField variant="outlined" size='small' label="Username" sx={classes.textField} />
            <TextField variant="outlined" size='small' label="Password" type="password" sx={classes.textField} />
            <TextField variant="outlined" size='small' label="Mobile number" type="number" sx={classes.textField} />
            <FormControl sx={{ flex: 1 }} size="small">
                <InputLabel>Select your units</InputLabel>
                <Select
                    sx={classes.select}
                >
                    <MenuItem value="">
                        <em>None</em>
                    </MenuItem>
                    <MenuItem value={10}>Ten</MenuItem>
                    <MenuItem value={20}>Twenty</MenuItem>
                    <MenuItem value={30}>Thirty</MenuItem>
                </Select>
            </FormControl>

            <Button sx={classes.registerButton} variant='contained'>Register</Button>



        </div>
    );
};