import { Box } from "@mui/material"
import { Navigate, Route, Routes } from "react-router-dom";

const classes = {
    wrapper: {
        backgroundColor: 'rgb(241, 245, 249)',
        minHeight: '95vh',
        width: '100%',
        flex: 1,
    }
} as const;

export const ApplicationTab = () => {
    return (
        <Box sx={classes.wrapper}>
            <Routes>
                <Route path='overview' element={<div>Hello from overview</div>} />
                <Route path='notifications' element={<div>Hello from notifications</div>} />
                <Route path='issues' element={<div>Hello from issues</div>} />
                <Route path='voting' element={<div>Hello from voting</div>} />
                <Route path='invoices' element={<div>Hello from invoices</div>} />
                <Route path='building-invoices' element={<div>Hello from building invoices</div>} />
                <Route path='documents' element={<div>Hello from documents</div>} />
                <Route path='*' element={<Navigate replace to="overview" />} />
            </Routes>
        </Box>
    )
}