import { Box } from "@mui/material"
import jwtDecode from "jwt-decode";
import { useEffect, useState } from "react";
import { Navigate, Route, Routes } from "react-router-dom";
import { getBuilding } from "../actions/data-manager";
import { JWT_TENANT } from "../actions/network-manager";
import { BuildingInvoices } from "./BuildingInvoices/BuildingInvoices";
import { Issues } from "./Issues/Issues";
import { Notifications } from "./Notifications/Notifications";
import { Settings } from "./Settings/Settings";
import { Voting } from "./Voting/Voting";

const classes = {
    wrapper: {
        backgroundColor: 'rgb(241, 245, 249)',
        minHeight: '95vh',
        width: '100%',
        boxSizing: 'border-box',
        paddingBlock: '3%',
        paddingInline: '11%',
        '@media (max-width: 800px)': {
            paddingInline: '5%',
        }
    }
} as const;

export const ApplicationTab = () => {

    const getBuildingId = () => {
        let res: any = jwtDecode(localStorage.getItem(JWT_TENANT)!);
        return res.bl[0].id;
    }

    const [buildingId, setBuildingId] = useState(getBuildingId());
    const [building, setBuilding] = useState<any>();

    useEffect(() => {
        getBuilding(buildingId, (err: any, data: any) => { setBuilding(data) });
    }, []);

    return (
        <Box sx={classes.wrapper}>
            { building &&
                <Routes>
                    <Route path='overview' element={<div>Hello from overview</div>} />
                    <Route path='notifications' element={<Notifications notifications={building.notifications}/>} />
                    <Route path='issues' element={<Issues issues={building.issues}/>} />
                    <Route path='voting' element={<Voting buildingId={buildingId} />} />
                    <Route path='invoices' element={<div>Hello from invoices</div>} />
                    <Route path='building-invoices' element={<BuildingInvoices buildingFinance={building.finance} />} />
                    <Route path='documents' element={<div>Hello from documents</div>} />
                    <Route path='settings' element={<Settings />} />
                    <Route path='*' element={<Navigate replace to="overview" />} />
                </Routes>
            }
        </Box>
    )
}