import { Box, Divider, Typography } from "@mui/material";
import { useEffect, useState } from "react";
import { Card } from "../Card/Card";
import { TabWrapper } from "../TabWrapper/TabWrapper";
import { Issue } from "./Issue";

export const Issues = ({ issues }: { issues: any }) => {


    const [open, setOpen] = useState(new Array(issues.length).fill(false));

    useEffect(() => {
        console.log(issues);
    }, []);

    return (
        <TabWrapper header="Aktivnosti">
            {
                issues.map((issue: any, index: number) => (
                    <Issue issue={issue} key={index}/>
                ))
            }
        </TabWrapper>
    );
}