import { Box, Typography } from "@mui/material"
import { ReactNode } from "react"
import './TabWrapper.css'

const classes = {
    wrapper: {
        display: 'flex',
        flexDirection: 'column',
        gap: '50px'
    },
    header: {
        fontWeight: 600,
        fontSize: '1.6em'
    }
} as const;

export const TabWrapper = ({header, children}: {header: string, children?: ReactNode}) => {
    return (
        <Box sx={classes.wrapper}>
            <Typography variant='h5' sx={classes.header}>{header}</Typography>
            {children}
        </Box>
    )
}