import { Box } from "@mui/material";
import { useEffect, useState } from "react"
import { useNavigate } from "react-router-dom"
import { JWT_TENANT } from "../actions/network-manager"
import { ApplicationTab } from "./ApplicationTab";
import { NavBar } from "./NavBar/NavBar";
import { SideMenu } from "./SideMenu/SideMenu";

const classes = {
    mainWrapper: {
        display: 'flex',
        flexDirection: 'row',
    },
    rightSideWrapper: {
        display: 'flex',
        flexDirection: 'column',
        flex: 1
    }
} as const;

export const Application = () => {

    const navigate = useNavigate();
    const [logedIn, setLogedIn] = useState(false);
    const [sideMenuOpen, setSideMenuOpen] = useState(false);

    const toggleSideMenu = (open: boolean) => {
        setSideMenuOpen(open);
    }

    useEffect(() => {
        if (!!localStorage.getItem(JWT_TENANT)) {
            setLogedIn(true);
            return;
        }

        navigate('../login');
    }, [navigate])

    return (
        <>
            {logedIn &&
                <Box sx={classes.mainWrapper}>
                    <SideMenu active={sideMenuOpen} toggleSideMenu={toggleSideMenu}/>
                    <Box sx={classes.rightSideWrapper}>
                        <NavBar toggleSideMenu={toggleSideMenu}/>
                        <ApplicationTab/>
                    </Box>
                </Box>
            }
        </>
    )
}