import { Box, Collapse, Divider, Typography } from "@mui/material";
import { display } from "@mui/system";
import { useState } from "react";
import { useTranslation } from "react-i18next";
import { Card } from "../Card/Card";
import { ExpandIcon } from "../icons/ExpandIcon";

const classes = {
    wrapper: {
        display: 'flex',
        flexDirection: 'column',
        gap: '50px',
    },
    header: {
        fontWeight: 600,
        fontSize: '1.6em',
    },
    subheader: {
        color: 'gray',
        fontSize: '0.9rem'
    },
    subject: {
        fontSize: '1.2rem'
    },
    button: {
        marginLeft: 'auto',
        borderRadius: '50px'
    }
} as const;

export const Issue = ({ issue }: { issue: any }) => {

    const [expand, setExpand] = useState(false);
    const {t} = useTranslation();

    return (
        <Card>
            <Box sx={{ display: 'flex', flexDirection: 'row', alignItems: 'center', gap: '20px' }}>
                <Typography sx={classes.subject}>{issue.title}</Typography>
                <Box sx={{ marginLeft: 'auto', transition: 'transform .25s', transform: `rotate(${expand ? 180 : 0}deg)`, width: '20px'}} onClick={() => { setExpand(!expand) }}>
                    <ExpandIcon />
                </Box>
                {/* <Typography sx={{ marginLeft: 'auto', transition: 'transform .5s', transform: `rotate(${expand ? 180 : 0}deg)` }} onClick={() => { setExpand(!expand) }}>V</Typography> */}

            </Box>
            <Box sx={{ display: 'flex', flexDirection: 'column', gap: '5px' }}>
                <Typography sx={classes.subheader}>Opis</Typography>
                <Typography>{issue.description}</Typography>
            </Box>
            <Collapse in={expand} timeout={250}>
                <Box sx={{ display: 'flex', flexDirection: 'column', gap: '5px' }}>
                    <Divider />
                    <Box sx={{ display: 'flex', flexDirection: 'column', gap: '5px' }}>
                        <Typography sx={classes.subheader}>Rešenja</Typography>
                        {issue.solutions.map((solution: any, ind: number) => (
                            <Box key={ind}>
                                <Typography >{`${ind + 1}. ${solution.name} - ${t("priceFormat", { num: (solution.price) })}`}</Typography>
                                <Typography sx={{ paddingLeft: '10px', fontSize: '15px' }}>{solution.description || 'Opis resenja nije unet.'}</Typography>
                            </Box>
                        ))}
                    </Box>
                </Box>
            </Collapse>
        </Card>
    );
}