import { Box } from "@mui/material";
import { useEffect, useState } from "react"
import { useNavigate } from "react-router-dom"
import { JWT_TENANT } from "../actions/network-manager"
import { ApplicationTab } from "./ApplicationTab";
import { NavBar } from "./NavBar";
import { SideMenu } from "./SideMenu";

const classes = {
    mainWrapper: {
        display: 'flex',
        flexDirection: 'row'
    },
    rightSideWrapper: {
        display: 'flex',
        flexDirection: 'column',
        width: '85%'
    }
} as const;

export const Application = () => {

    const navigate = useNavigate();
    const [logedIn, setLogedIn] = useState(false);

    useEffect(() => {
        if (!!localStorage.getItem(JWT_TENANT)) {
            setLogedIn(true);
            return;
        }

        navigate('../login');
    }, [navigate])

    return (
        <>
            {logedIn &&
                <Box sx={classes.mainWrapper}>
                    <SideMenu />
                    <Box sx={classes.rightSideWrapper}>
                        <NavBar />
                        <ApplicationTab />
                    </Box>
                </Box>
            }
        </>
    )
}