import { Box, Typography } from "@mui/material";
import { useEffect, useState } from "react";
import { getTenantInfo } from "../actions/data-manager";
import { SubMenu } from "../internal-types";
import { SideMenuItem } from "./SideMenuItem";
import { ActivityIcon } from "./icons/ActivityIcon";
import { HomeIcon } from "./icons/HomeIcon";
import { NotificationIcon } from "./icons/NotificationIcon";
import { VotingIcon } from "./icons/VotingIcon";
import { InvoicesIcon } from "./icons/InvoicesIcon";
import { BuidlingInvoicesIcon } from "./icons/BuildingInvoicesIcon";
import { DocumentIcon } from "./icons/DocumentIcon";
import { SettingsIcon } from "./icons/SettingsIcon";
import { LanguageIcon } from "./icons/LanguageIcon";
import { LogoutIcon } from "./icons/LogoutIcon";
import { UserIcon } from "./icons/UserIcon";


const subMenu: SubMenu[] = [
    {
        title: 'Glavni meni',
        items: [
            { title: 'Pregled', icon: <HomeIcon /> },
            { title: 'Obaveštenja', icon: <NotificationIcon /> },
            { title: 'Aktivnosti', icon: <ActivityIcon /> },
            { title: 'Glasanje', icon: <VotingIcon /> }
        ]
    },
    {
        title: 'Računi/Finansije',
        items: [
            { title: 'Moj Račun', icon: <InvoicesIcon /> },
            { title: 'Finansije zgrade', icon: <BuidlingInvoicesIcon /> },
            { title: 'Dokumenta', icon: <DocumentIcon /> }]
    },
    {
        title: 'Aplikacija',
        items: [
            { title: 'Podešavanja', icon: <SettingsIcon /> },
            { title: 'Language', icon: <LanguageIcon /> }]
    }

];

const classes = {
    wrapper: {
        width: '15%',
        backgroundColor: 'rgba(19, 34, 50, 1)',
        height: '100vh',
        position: 'sticky',
        top: '0px'
    },
    content: {
        display: 'flex',
        flexDirection: 'column',
        paddingInline: '3%',
        paddingBlock: '7.5%',
        gap: '30px'
    },
    logo: {
        width: '75%',
        alignSelf: 'center'
    },
    accountInfo: {
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center',
        gap: '5px'
    },
    menuText: {
        color: 'rgb(204, 217, 232)',
        margin: '0px',
        fontFamily: 'Inter',
    },
    boldText: {
        fontWeight: 'bolder',
    },
    signOut: { 
        display: 'flex', 
        flexDirection: 'row', 
        width: '100%', 
        justifyContent: 'center', 
        gap: '10px', 
        alignItems: 'center' 
    }
} as const;

export const SideMenu = () => {

    const [tenantInfo, setTenantInfo] = useState<any>();

    useEffect(() => {
        getTenantInfo((err: any, data: any) => {
            setTenantInfo(data);
        })
    }, []);

    return (
        <>
            {
                tenantInfo &&
                <Box sx={classes.wrapper}>
                    <Box sx={classes.content}>
                        {/* TODO Create component for logo as well. */}
                        <img src={process.env.PUBLIC_URL + '/assets/logo-svg.svg'} alt='logo' style={classes.logo} />
                        <Box sx={classes.accountInfo}>
                            <UserIcon />
                            <Typography variant="body1" sx={{ ...classes.menuText, ...classes.boldText }}>{tenantInfo.firstName}</Typography>
                            <Typography style={classes.menuText}>{tenantInfo.email}</Typography>

                            <Box sx={classes.signOut}>
                                <Typography style={classes.menuText}>Sign out</Typography>
                                <LogoutIcon />
                            </Box>
                        </Box>
                        {subMenu.map((menu, index) => (
                            <SideMenuItem key={index} content={menu} />
                        ))}
                    </Box>
                </Box>
            }
        </>
    );
}