import { TextField, Box, Button, Select, FormControl, InputLabel, MenuItem, Typography } from "@mui/material";
import React, { useEffect, useState } from "react";
import { useNavigate, useParams } from "react-router-dom";
import { getPreRegisterData, registerUser } from "../../actions/data-manager";
import { RegistrationInfo } from "../../internal-types";

const classes = {
    wrapper: {
        height: '100%',
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        gap: '20px'
    },
    title: {
        fontFamily: 'Inter',
        fontWeight: 'bold',
    },
    nameWrapper: { 
        display: 'flex', 
        gap: '20px' 
    },
    textField: {
        '& label.Mui-focused': {
            color: 'rgb(30, 41, 60)'
        },
        '& .MuiOutlinedInput-root': {
            '& input': {
                zIndex: '5'
            },
            '& fieldset': {
                borderColor: 'rgb(203, 213, 224)',
                backgroundColor: 'white'
            },
            '&:hover fieldset': {
                borderColor: 'rgb(203, 213, 224)',
            },
            '&.Mui-focused': {
                '& fieldset': {
                    borderColor: 'rgb(203, 213, 224)'
                }
            },
        }
    },
    select: {
        '& label.Mui-focused': {
            color: 'red'
        }
        ,
        '& fieldset': {
            borderColor: 'rgb(203, 213, 224)',
            backgroundColor: 'white',
            zIndex: 0
        },
        '& svg': {
            zIndex: 2
        },
        '& div': {
            zIndex: 3
        },

    },
    registerButton: {
        alignSelf: 'flex-end',
        '&.MuiButton-root': {
            backgroundColor: 'rgb(19, 71, 175)',
            borderRadius: 40,
            padding: '10px',
            paddingInline: '25px'
        }
    }
} as const;

export const RegisterForm = (): JSX.Element => {

    // TODO Add proper frontend validation

    let navigate = useNavigate();

    let { buildingId } = useParams();

    const [buildingUnits, setBuildingUnits] = useState([]);
    const [registerInfo, setRegisterInfo] = useState<RegistrationInfo>(
        { firstName: '', lastName: '', email: '', username: '', password: '', mobile: '', pendingBuildings: { id: buildingId!, units: [] } });
    const [errorField, setErrorField] = useState('');
    const [errorMessage, setErrorMessage] = useState('');

    const registerCallBack = (err: any, data: any, dsp: any) => {

        if (!!err) {
            if (err.wrongField) {
                setErrorField(err.wrongField);
                setErrorMessage(err.errorMessage);
            }
            return;
        }

        navigate('../../login', { replace: true });
    }

    useEffect(() => {
        getPreRegisterData(buildingId, (err: any, data: any, dsp: any) => {
            if (err) {
                navigate('../register/error', { replace: true });
                return;
            }
            setBuildingUnits(data.units);
        });
    }, [buildingId, navigate]);

    const handleKeyUp = (event: React.KeyboardEvent<HTMLDivElement>): void => {
        if (event.key === 'Enter') {
            registerUser(buildingId, registerInfo, registerCallBack);
        }
    }

    return (
        <>
            {buildingUnits &&
                <Box style={classes.wrapper} onKeyUp={handleKeyUp}>
                    <Typography sx={classes.title} variant='h4'>Create Account</Typography>
                    <Box sx={classes.nameWrapper}>
                        <TextField
                            hiddenLabel
                            variant="outlined"
                            size='small'
                            label="First name"
                            sx={{...classes.textField, flex: 1}}
                            value={registerInfo.firstName}
                            onChange={(e) => {
                                setRegisterInfo({ ...registerInfo, firstName: e.target.value })
                            }}
                            error={"firstName" === errorField}
                            helperText={"firstName" === errorField ? errorMessage : null}
                            autoFocus
                        />
                        <TextField
                            hiddenLabel
                            variant="outlined"
                            size='small'
                            label="Last name"
                            sx={{...classes.textField, flex: 1}}
                            value={registerInfo.lastName}
                            onChange={(e) => {
                                setRegisterInfo({ ...registerInfo, lastName: e.target.value })
                            }}
                            error={"lastName" === errorField}
                            helperText={"lastName" === errorField ? errorMessage : null}
                        />
                    </Box>

                    <TextField
                        variant="outlined"
                        size='small'
                        label="Email"
                        sx={classes.textField}
                        value={registerInfo.email}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, email: e.target.value })
                        }}
                        error={"email" === errorField}
                        helperText={"email" === errorField ? errorMessage : null}
                    />
                    <TextField
                        variant="outlined"
                        size='small'
                        label="Username"
                        sx={classes.textField}
                        value={registerInfo.username}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, username: e.target.value })
                        }}
                        error={"username" === errorField}
                        helperText={"username" === errorField ? errorMessage : null}
                    />
                    <TextField
                        variant="outlined"
                        size='small'
                        label="Password"
                        type="password"
                        sx={classes.textField}
                        value={registerInfo.password}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, password: e.target.value })
                        }}
                    />
                    <TextField
                        variant="outlined"
                        size='small'
                        label="Mobile number"
                        type="number"
                        sx={classes.textField}
                        value={registerInfo.mobile}
                        onChange={(e) => {
                            setRegisterInfo({ ...registerInfo, mobile: e.target.value })
                        }}
                        error={"mobile" === errorField}
                        helperText={"mobile" === errorField ? errorMessage : null}
                    />
                    <FormControl fullWidth size="small" onKeyUp={(e) => {e.stopPropagation();}}>
                        <InputLabel>Select your units</InputLabel>
                        <Select
                            label="Select your units"
                            sx={classes.select}
                            value={registerInfo.pendingBuildings.units}
                            multiple
                            onChange={(e) => {
                                let units: string[] = typeof e.target.value === 'string' ? e.target.value.split(',') : e.target.value;
                                setRegisterInfo({ ...registerInfo, pendingBuildings: { ...registerInfo.pendingBuildings, units } })
                            }}
                            error={"units" === errorField}
                        >
                            {buildingUnits.map((unit: any, index) => <MenuItem value={unit} key={index}>{unit.address}</MenuItem>)}
                        </Select>
                    </FormControl>

                    <Button
                        sx={classes.registerButton}
                        variant='contained'
                        onClick={() => {
                            registerUser(buildingId, registerInfo, registerCallBack);
                        }}
                    >Register</Button>
                </Box>
            }
        </>);
};