import { Table, TableBody, TableCell, TableContainer, TableHead, TableRow } from "@mui/material";
import { useTranslation } from "react-i18next";
import { Card } from "../Card/Card";
import { DownloadIcon } from "../icons/DownloadIcon";
import { LinkIcon } from "../icons/LinkIcon";

const classes = {
    tableHead: {
        '& .MuiTableCell-root': {
            color: '#64748b',
            fontWeight: 'bold',
            paddingBlock: '8px',
            paddingInline: '0px',
        }
    },
    tableBody: {
        '& .MuiTableCell-root': {
            paddingInline: '0px',
        }
    },
    bolder: {
        fontWeight: 'bolder'
    },
    status: {
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center'
    }

} as const;

export const DocumentsList = ({ documents }: { documents: any }) => {

    const { t } = useTranslation();

    return (
        <Card>
            <TableContainer >
                <Table size="medium">
                    <TableHead>
                        <TableRow sx={classes.tableHead}>
                            <TableCell align="left">{t("Name")}</TableCell>
                            <TableCell align="center">{t("Date")}</TableCell>
                            <TableCell align="center">{t("Action")}</TableCell>
                        </TableRow>
                    </TableHead>
                    <TableBody>
                        {documents.map((payable: any) => (
                            <TableRow key={payable._id} sx={classes.tableBody}>
                                <TableCell align="left">{payable.name} </TableCell>
                                <TableCell align="center">{t("formatDate", { date: new Date(payable.created) })}</TableCell>
                                <TableCell align="center"><a href={payable.link}>{(payable.link.includes('dropboxusercontent')) ? <DownloadIcon /> : <LinkIcon />} </a></TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </TableContainer>
        </Card>
    );
}