import { Box, Button, TextField, Typography } from "@mui/material";
import { useEffect, useState } from "react";
import { getTenantInfo } from "../../actions/data-manager";
import { Card } from "../Card/Card";
import { CheckMark } from "../icons/CheckMark";
import { keyToBase64, PRIVATE_KEY } from "../register/RegisterForm";
import { TabWrapper } from "../TabWrapper/TabWrapper";
import { Buffer } from "buffer";
import nacl, { verify } from "tweetnacl";

const classes = {
    votingSeetings: { 
        display: 'flex', 
        flexDirection: 'row', 
        alignItems: 'center' 
    },
    textWrapper: { 
        display: 'flex', 
        flexDirection: 'column', 
        gap: '15px' 
    },
    header: { 
        color: 'gray', 
        fontSize: '0.9rem' 
    },
    button: { 
        marginLeft: 'auto', 
        borderRadius: '50px' 
    }

} as const;

export const Settings = () => {

    const [privateKey, setPrivateKey] = useState(localStorage.getItem(PRIVATE_KEY));
    const [publicKey, setPublicKey] = useState();
    const [newPrivateKey, setNewPrivateKey] = useState('');
    const [helperText, setHelperText] = useState('');


    useEffect(() => {
        getTenantInfo((err: any, user: any) => {
            if (user.voting.hasVotingKey) {
                setPublicKey(user.votingKey);
            }
        });
    }, []);

    const verifyKey = () => {
        try {
            let buf = Buffer.from(newPrivateKey, 'base64');
            let keyPair = nacl.sign.keyPair.fromSecretKey(buf);

            if (keyToBase64(keyPair.publicKey) === publicKey) {
                setPrivateKey(newPrivateKey);
                localStorage.setItem(PRIVATE_KEY, newPrivateKey);
                setHelperText('');
            }
        } catch (error) {
            setHelperText('Neispravan kljuc!');
        }
    }

    return (
        <TabWrapper header="Podešavanja">
            <Card>
                {!!privateKey &&
                    <Box sx={classes.votingSeetings}>
                        <Box sx={classes.textWrapper}>
                            <Typography sx={classes.header}>Glasanje</Typography>
                            <Typography>Privatni ključ je uspešno podešen u aplikaciji.</Typography>
                        </Box>
                        <CheckMark />
                    </Box>
                }
                {
                    !privateKey &&
                    <>
                        <Typography sx={classes.header}>Glasanje</Typography>
                        <Typography>Kako bi mogli da učestvujete u glasanju, molimo vas unesite vaš privatni ključ.</Typography>
                        <TextField
                            error={!!helperText}
                            helperText={helperText}
                            onChange={(e) => {
                                setNewPrivateKey(e.target.value);
                            }} size='small' />
                        <Button variant='contained' sx={classes.button} onClick={verifyKey}>Potvrdi</Button>
                    </>
                }
            </Card>

        </TabWrapper>
    );
}