import { ReactElement } from "react"

export type RegistrationInfo = {
    firstName: string,
    lastName: string,
    email: string,
    username: string,
    password: string,
    mobile: string,
    pendingBuildings: {
        id: string,
        units: string[]
    },
    publicKey?: string
}

export type LoginInfo = {
    username: string,
    password: string
}

export type SubMenu = {
    title: string,
    items: SubMenuItem[]
}

export type SubMenuItem = {
    icon?: ReactElement,
    title: string,
    path?: string
}

export type Vote = {
    votedTime: Date,
    unit: string,
    user: string,
    vote: string,
    signature: string,
    type: string
}

export type Candidate = {
    _id: string,
    name: string,
    link: string,
    votes: Vote[]
}

export type VotingEntity = {
    _id: string, 
    subject: string,
    description?: string,
    start: Date,
    end: Date,
    status: string,
    candidates: Candidate[],
    selection: string,
    winner: string,
    currentResults: {
        voted: number,
        totalSelection: number,
        quorum: number,
        unavailable: number
    }, 
    repeating: number
}